/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.core.network.message;

import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.config.spec.ItemSettingsConfig;
import com.momosoftworks.coldsweat.config.spec.MainSettingsConfig;
import com.momosoftworks.coldsweat.config.spec.WorldSettingsConfig;
import com.momosoftworks.coldsweat.core.network.ColdSweatPacketHandler;
import com.momosoftworks.coldsweat.util.ClientOnlyHelper;
import com.momosoftworks.coldsweat.util.serialization.RegistryHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class SyncConfigSettingsMessage {
    public static final UUID EMPTY_UUID = new UUID(0L, 0L);
    Map<String, CompoundTag> configValues;
    UUID menuOpener;

    public SyncConfigSettingsMessage(RegistryAccess registryAccess) {
        this(EMPTY_UUID, registryAccess);
    }

    public SyncConfigSettingsMessage(UUID menuOpener, RegistryAccess registryAccess) {
        this(ConfigSettings.encode(registryAccess), menuOpener);
    }

    private SyncConfigSettingsMessage(Map<String, CompoundTag> values, UUID menuOpener) {
        this.configValues = values;
        this.menuOpener = menuOpener;
    }

    public static void encode(SyncConfigSettingsMessage message, FriendlyByteBuf buffer) {
        buffer.m_130077_(message.menuOpener);
        buffer.writeInt(message.configValues.size());
        for (Map.Entry<String, CompoundTag> entry : message.configValues.entrySet()) {
            buffer.m_130070_(entry.getKey());
            buffer.m_130079_(entry.getValue());
        }
    }

    public static SyncConfigSettingsMessage decode(FriendlyByteBuf buffer) {
        UUID menuOpener = buffer.m_130259_();
        int size = buffer.readInt();
        HashMap<String, CompoundTag> values = new HashMap<String, CompoundTag>();
        for (int i = 0; i < size; ++i) {
            values.put(buffer.m_130277_(), buffer.m_130260_());
        }
        return new SyncConfigSettingsMessage(values, menuOpener);
    }

    public static void handle(SyncConfigSettingsMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            RegistryAccess registryAccess = RegistryHelper.getRegistryAccess();
            if (context.getDirection().getReceptionSide().isServer()) {
                if (context.getSender() != null && context.getSender().m_20310_(2)) {
                    message.configValues.forEach((name, values) -> ConfigSettings.decode(name, values, registryAccess));
                    ConfigSettings.saveValues(registryAccess);
                    MainSettingsConfig.getInstance().save();
                    WorldSettingsConfig.getInstance().save();
                    ItemSettingsConfig.getInstance().save();
                }
                ColdSweatPacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new SyncConfigSettingsMessage(EMPTY_UUID, registryAccess));
            } else if (context.getDirection().getReceptionSide().isClient()) {
                message.configValues.forEach((name, values) -> ConfigSettings.decode(name, values, registryAccess));
                if (message.menuOpener.equals(ClientOnlyHelper.getClientPlayer().m_20148_())) {
                    ClientOnlyHelper.openConfigScreen();
                }
            }
        });
        context.setPacketHandled(true);
    }
}

